use XML::Parser;

$style = 'linux.css';
open(Debug, ">t");
open(Title, "<../template/title.html");
while (<Title>)
{
    s/!Stylesheet/$style/g;
    $Title .= $_;
}
close(Title);

open(Bottom, "<../template/bottom");
while (<Bottom>) { $Bottom .= $_; }
close(Bottom);

open(Top, "<../template/top");
while (<Top>) 
{
    s/!Stylesheet/$style/g;
    $Top .= $_;
}
close(Top);

open(Out, ">tmp-show");

$slnum = 2;
@xml_space = ();

@startPairs = 
(
 'nt',       "<span class='nt'>",
 'term',     "<span class='term'>",
 'intro',    "<p class='intro'>",
 'caption',  "<p align='center' class='intro'>",
 'dt',       "<dt><span class='dt'>",
 'dd',       "<dd><span class='dd'>",
 'bigURL',   "<h3 align='center' class='bigU'>",
 'title',    "<div align='center' class='title'>",
 'bigTitle', "<div align='center' class='bigT'>"
 );

@endPairs = 
(
 'nt',     '</span>',
 'intro',  '</p>',
 'caption','</p>',
 'point',  '</span></li>',
 'eg',     '</span></td></tr></table></div>',
 'dt',     '</dt></span>',
 'dd',     '</dd></span>',
 'bigURL', '</h3>',
 'title',  '</div>',
 'bigTitle',  '</div>',
 );

@suppress = 
(
  'show', 'showTitle', 'showLoc'
 );

foreach $i (0 .. (@startPairs/2)-1)
{
    $startSubs{$startPairs[$i * 2]} = $startPairs[($i * 2) + 1];
}
foreach $i (0 .. (@endPairs/2)-1)
{
    $endSubs{$endPairs[$i * 2]} = $endPairs[($i * 2) + 1];
}
foreach $i (@suppress) { $suppress{$i} = 1; }

my $p = new XML::Parser Style => 'stream';

parsefile $p $ARGV[0];

$slideNum = 1;

sub EndDocument
{
    my $thisSl = 1;
    $slnum--;
    open(Slide, ">show/index.html");
    close(Out);
    open(In, "<tmp-show");
    while (<In>)
    {
	if (/<newSlide>/)
	{
	    close(Slide);
	    $thisSl++;
	    open(Slide, ">show/s-$thisSl.html");
	    $out = $Top;
	    $out =~ s/!Title/Slide $thisSl/;
	    print Slide $out;
	    next;
	}
	elsif (!/<!--Buttons Here-->/) 
	{
	    s/\$.w//g;
	    print Slide;
	    next;
	}

	print Slide "<div align='center' class='buttons'>\n";
	my $i;

	foreach $i (1 .. $slnum)
	{
	    if ($i == 1)
	    { print Slide "<a href='index.html'><img border='0' src='../../template/ws.gif' alt='Title Page'></img></a>\n"; }
	    elsif ($thisSl == $i)
	    { print Slide "<a href='s-$i.html'><img border='0' src='../../template/rs.gif' alt=\"$stitles[$i]\"></img></a>\n"; }
	    else
	    { print Slide "<a href='s-$i.html'><img border='0' src='../../template/ws.gif' alt=\"$stitles[$i]\"></img></a>\n"; }
	}
	print Slide "</div>\n";
    }
    close(In);
    close(Slide);
    $slnum++;
    open(In, "<show/index.html");
    open(Out, ">show/s-$slnum.html");
    while (<In>) { print Out $_; }
    close(In); close(Out);
}

sub StartTag
{
    if ($_{'xml:space'} eq 'preserve') { push(@xml_space, 'preserve'); }
    else { push(@xml_space, 'default'); }
    my $rep;
    my $type = $_[0];
    if ($rep = $startSubs{$type}) { print Out $rep; }
    elsif ($suppress{$type}) { return; }

    elsif (/<slide>/)
    {
	$didUL = 0;
	print Out "<newSlide>\n";
	print Out "<A NAME='s-$slnum'></A>\n" unless ($slnum == 1);
    }
    elsif (/<point>/)
    {
	if ($p->{Context}[-1] ne "ol" && !$didUL)
	{
	    print Out "<UL>\n";
	    $didUL = 1;
	}
	print Out '<li class="number"><span class="question">';
    }
    elsif ($type eq "pic")
    {
	if ($didUL) { print Out "</UL>"; }
	print Out "<p align='center'><IMG SRC='../$_{href}'></IMG></p>";
	if ($didUL) { print Out "<UL>"; }
    }
    elsif ($type eq "eg")
    {
	print Out "<div align='center'><table bgcolor='white' cellpadding='10'><tr><td valign='middle'>";
	print Out "<span class='eg$_{size}'>"
    }
    elsif ($type eq 'head') { $out = $Title; }
    else { print Out; }
}

sub EndTag
{
    pop(@xml_space);

    my $rep;
    my $type = $_[0]; 

    if ($rep = $endSubs{$type}) { print Out $rep; }
    elsif ($suppress{$type}) { return; }

    elsif (/<\/slide>/)
    {
	if ($didUL) { print Out "</UL>\n"; }
	$out = $Bottom;
	$slnum++;
	$out =~ s/!Next/$slnum/;
	&dumpOut();
    }
    elsif ($type eq 'head') { &dumpOut(); }
    else { print Out; }
}

sub Text
{
    my $in = $p->{Context}[-1];
    if ($in eq "showTitle")
    {
	$showTitle = $_;
	$out =~ s/!Title/$showTitle/g;
    }
    elsif ($in eq "showLoc")
    {
	$out =~ s/!Where/$_/g;
    }
    elsif ($in eq "eg")
    {
	my $x = fix($_);
	print Debug "in [$_], out [$x]\n";
	$x =~ s/\n/<br>/g;
	print Out $x;
    }
    elsif ($in eq "title" || $in eq "bigTitle")
    {
	$stitles[$slnum] = $_;
	print Out fix($_);
    }
    else { print Out fix($_); }
}

sub fix
{
    my $t = $_[0];
    $t =~ s/&/&amp;/g;
    $t =~ s/</&lt;/g;
    $t =~ s/>/&gt;/g;

    if (grep(/preserve/, @xml_space)) { $t =~ s/ /&nbsp;/g; }
    return($t);
}

sub dumpOut
{
  $prev = $slnum - 1;
  $next = $slnum + 1;
  if ($slnum > 1) 
  { $out =~ s/!prev/#s-$prev/; }
  $out =~ s/!next/#s-$next/;
  print Out $out;
}

#sub doTop
#{
#    my $tl = $_[0];
#    $out = $Top;
#    $out =~ s/!Title/$tl/;
#    &dumpOut();
#}
#
#sub doBigT
#{
#    my $tl = "<br>$_[0]";
#    $out = $Top;
#    $out =~ s@!Title@$tl@;
#    $out =~ s/class="title"/class="bigT"/g;
#    &dumpOut();
#}




